/*
 * Decompiled with CFR 0.152.
 */
package test.dom;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.PlotElement;
import org.das2.util.LoggerManager;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;

public class BindingTest {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot");

    public static void bind(DomNode master, String prop, DomNode p, String destProp, Converter c) {
        BeanProperty bp = BeanProperty.create((String)prop);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)master, (Property)bp, (Object)p, (Property)BeanProperty.create((String)destProp));
        binding.bind();
    }

    private static PropertyChangeListener propListener(final Object p, final BeanProperty bp, final Converter c, final boolean forward) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object value = evt.getNewValue();
                if (c == null) {
                    bp.setValue(p, value);
                } else if (forward) {
                    bp.setValue(p, c.convertForward(value));
                } else {
                    bp.setValue(p, c.convertReverse(value));
                }
            }
        };
    }

    public static void bind2(DomNode master, String prop, Object p, String destProp, Converter c) {
        BeanProperty bp = BeanProperty.create((String)prop);
        BeanProperty dbp = BeanProperty.create((String)destProp);
        master.addPropertyChangeListener(prop, BindingTest.propListener(p, dbp, c, true));
        try {
            Method apcl = p.getClass().getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
            apcl.invoke(p, destProp, BindingTest.propListener(master, bp, c, false));
        }
        catch (IllegalAccessException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (InvocationTargetException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (NoSuchMethodException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (SecurityException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public static void main(String[] args) {
        ArrayList<PlotElement> plotElements1 = new ArrayList<PlotElement>();
        PlotElement master = new PlotElement();
        for (int i = 0; i < 40; ++i) {
            plotElements1.add(new PlotElement());
        }
        long t0 = System.currentTimeMillis();
        for (PlotElement p : plotElements1) {
            BindingTest.bind2(master, "legendLabel", p, "legendLabel", null);
            System.err.printf("%5d: bind %s\n", System.currentTimeMillis() - t0, p);
        }
        System.err.printf("%5d: done bindings \n", System.currentTimeMillis() - t0);
        for (int i = 0; i < 10; ++i) {
            master.setLegendLabel("foo" + i);
            System.err.println(((PlotElement)plotElements1.get(20)).getLegendLabel());
        }
        System.err.printf("%5d: done \n", System.currentTimeMillis() - t0);
    }
}

